package cn.com.duiba.cloud.duiba.payment.service.api.param;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 绑定账户查询
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/05/17 10:46 上午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class PayCreditQueryParam extends PageRequest {

    private static final long serialVersionUID = 8224815378928281119L;
    /**
     * 用户类型
     */
    private Integer userType;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 应用列表
     */
    private List<Long> userIdList;

    /**
     * 授信账户类型
     */
    private Integer accountType;

    /**
     * 授信账户类型
     */
    private List<Integer> accountTypeList;

    /**
     * 是否有效
     */
    private Boolean isValid;

    /**
     * 是否有剩余
     */
    private Boolean haveSurplus;

    /**
     * 是否过期
     */
    private Boolean isOverdue;

    /**
     * 现在及之前
     */
    private Boolean isNowBefore;

    /**
     * 是否需要冲销
     */
    private Boolean needFill;

    private Boolean isDelete;
}
