package cn.com.duiba.cloud.duiba.payment.service.api.param;

import cn.com.duiba.cloud.duiba.payment.service.api.model.PayUserBase;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 三方转账请求
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/7/14 8:19 下午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class ThirdTransferParam extends PayUserBase {
    private static final long serialVersionUID = 2533556648739984020L;

    /**
     * 转账业务的标题，用于在三方用户的账单里显示。
     */
    private String orderTitle;

    /**
     * 支付方式
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PayMethodEnum
     */
    @NotNull(message = "支付方式不能为空")
    private Integer payMethod;

    /**
     * 转账金额
     */
    private Long transferAmount;

    /**
     * 业务编号（唯一、幂等）
     */
    private String bizNo;

    /**
     * 收款方账户
     */
    private String identity;

    /**
     * 收款人姓名
     */
    private String name;

    /**
     * 备注-对外账单会展示
     */
    private String remark;
}
