/**
 * Copyright (c) 2019- All Rights Reserved.
 */
package cn.com.duiba.cloud.duiba.payment.service.api.param;

import cn.com.duiba.cloud.duiba.payment.service.api.model.PayUserBase;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

/**
 * 交易发起支付
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/22 4:53 下午
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class TradePayParam extends PayUserBase {

    private static final long serialVersionUID = 8711877318228002734L;

    /**
     * 支付方式
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PayMethodEnum
     */
    @NotNull(message = "支付方式不能为空")
    private Integer payMethod;

    /**
     * 支付子方式
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PaySubMethodEnum
     */
    @NotNull(message = "支付子方式不能为空")
    private Integer paySubMethod;

    /**
     * 订单标题（对用户透出，支付的时候会看到）
     */
    private String subject;

    /**
     * 支付key
     */
    @NotNull(message = "支付Key不能为空")
    private String payKey;

    /**
     * 微信支付用户标示 openid
     */
    private String openid;

    /**
     * 操作的innerUserId
     */
    private Long innerUserId;
}
