package cn.com.duiba.cloud.duiba.payment.service.api.param;

import cn.com.duiba.cloud.duiba.payment.service.api.model.PayUserBase;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.NonNull;

/**
 * 转账单请求
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/8 2:11 下午
 **/
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class TransferOrderParam extends PayUserBase {

    private static final long serialVersionUID = 2484091971020308493L;

    /**
     * 账户类型
     */
    @NonNull
    private Integer accountType;

    /**
     * to用户类型（租户、普通用户等）
     * user_type
     */
    @NonNull
    private Integer toUserType;

    /**
     * to用户id
     * to_user_id
     */
    @NonNull
    private Long toUserId;


    /**
     * to账户
     */
    @NonNull
    private Integer toAccountType;

    /**
     * 转账编号
     */
    @NonNull
    private String transferNo;

    /**
     * 转账金额
     * refundAmount
     */
    @NonNull
    private Long transferAmount;

    /**
     * 转账原因，会在用户账单中看到，请严格处理
     */
    private String transferReason;
}
