package cn.com.duiba.cloud.duiba.payment.service.api.param.app;

import cn.com.duiba.cloud.duiba.payment.service.api.dto.OnlinePayDTO;
import cn.com.duiba.cloud.duiba.payment.service.api.enums.PayAccountTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author sunyan
 */
@Data
public class AppAccountOnlineRechargeParam implements Serializable {
    private static final long serialVersionUID = -9203334319716765913L;
    /**
     * 应用Id
     */
    private Long appId;

    /**
     * 充值金额
     */
    private Long totalAmount;

    /**
     * 主体类型（从management查）
     */
    private Integer businessEntityType;

    /**
     * 手续费
     */
    private Long fee;

    /**
     * 账户类型
     *
     * @see PayAccountTypeEnum
     */
    private Integer accountType;

    /**
     * 支付方式（充值方式）
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PayMethodEnum
     */
    private Integer payMethod;

    /**
     * 业务编号（渠道流水号）
     */
    private String bizNo;

    /**
     * 备注
     */
    private String memo;

    /**
     * 扩展字端
     */
    private OnlinePayDTO onlinePayDTO;
}
