package cn.com.duiba.cloud.duiba.payment.service.api.param.app;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 应用订单退款（应用-》兑吧）
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/5/16 2:07 下午
 **/
@Data
public class AppOrderRefundParam implements Serializable {
    private static final long serialVersionUID = -618553634214266457L;
    /**
     * 应用Id
     */
    @NotNull(message = "应用Id不能为空")
    private Long appId;

    /**
     * 业务编号（退款单号）
     */
    @NotNull(message = "业务编号不能为空")
    private String bizNo;

    /**
     * 父类业务编号
     */
    @NotBlank(message = "父类业务编号不能为空")
    private String parentBizNo;

    /**
     * 相关主订单
     */
    @NotBlank(message = "相关主订单不能为空")
    private String mainOrder;

    /**
     * 相关子订单
     */
    @NotNull(message = "相关子订单不能为空")
    private List<String> subOrderList;

    /**
     * 开发者订单号
     */
    private String developOrder;

    /**
     * 主体类型（从management查）
     */
    @NotNull(message = "主体类型不能为空")
    private Integer businessEntityType;

    /**
     * 退款金额
     */
    @NotNull(message = "退款金额不能为空")
    private Long refundAmount;
}
