package cn.com.duiba.cloud.duiba.payment.service.api.param.budget;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 预算操作
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/5/16 3:05 下午
 **/
@Data
public class BudgetOptParam implements Serializable {
    private static final long serialVersionUID = -5492546002231486233L;
    /**
     * 用户id
     */
    @NotNull(message = "用户id不能为空")
    private Long userId;

    /**
     * 用户类型
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PayUserTypeEnum
     */
    @NotNull(message = "用户类型不能为空")
    private Integer userType;

    /**
     * 预算来源
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PayBudgetSourceEnum
     */
    @NotNull(message = "预算来源不能为空")
    private Integer budgetSource;

    /**
     * 预算类型
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PayBudgetTypeEnum
     */
    @NotNull(message = "预算类型不能为空")
    private Integer budgetType;

    /**
     * 操作金额（分）
     */
    @NotNull(message = "不能为空")
    private Long optAmount;

    /**
     * 预算时间
     */
    @NotNull(message = "预算时间不能为空")
    private Date budgetDate;

    /**
     * 业务编号（一小时幂等）
     */
    @NotNull(message = "业务编号不能为空")
    private String bizNo;
}
