package cn.com.duiba.cloud.duiba.payment.service.api.param.budget;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 预算设置
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/5/16 3:05 下午
 **/
@Data
public class BudgetSettingParam implements Serializable {
    private static final long serialVersionUID = -5492546002231486233L;
    /**
     * 用户id
     */
    @NotNull(message = "userId不能为空")
    private Long userId;

    /**
     * 用户类型
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PayUserTypeEnum
     */
    @NotNull(message = "用户类型不能为空")
    private Integer userType;

    /**
     * 预算来源
     *
     * @see cn.com.duiba.cloud.duiba.payment.service.api.enums.PayBudgetSourceEnum
     */
    @NotNull(message = "预算来源不能为空")
    private Integer budgetSource;

    /**
     * 每日普兑预算
     */
    private Long dailyExchangeBudget;


    /**
     * 每月普兑预算
     */
    private Long monthlyExchangeBudget;

    /**
     * 每日活动普兑预算
     */
    private Long dailyActivityBudget;

    /**
     * 每月活动普兑预算
     */
    private Long monthlyActivityBudget;
}
