package cn.com.duiba.cloud.duiba.payment.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.payment.service.api.dto.BindAccountInfoDTO;
import cn.com.duiba.cloud.duiba.payment.service.api.param.BindAccountParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.BindAccountQueryParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.BindAccountUpdateParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 绑定账户（未使用）
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/9 10:02 上午
 **/
@AdvancedFeignClient
public interface RemoteBindAccountService {

    /**
     * 获取绑定账户列表
     *
     * @param bindAccountQueryParam
     * @return
     */
    PageResponse<BindAccountInfoDTO> getBindAccountForPage(BindAccountQueryParam bindAccountQueryParam);

    /**
     * 更新绑定账号<br/>
     * 删除也走更新，进行软删除
     *
     * @param bindAccountUpdateParam
     */
    void updateBindAccount(BindAccountUpdateParam bindAccountUpdateParam) throws BizException;

    /**
     * 绑定的账户
     *
     * @param bindAccountParam
     */
    void bindAccount(BindAccountParam bindAccountParam) throws BizException;

    /**
     * 获取绑定账户
     *
     * @param bindId
     * @return
     */
    BindAccountInfoDTO getBindAccountById(Long bindId);
}
