package cn.com.duiba.cloud.duiba.payment.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.payment.service.api.dto.CashierInfoDTO;
import cn.com.duiba.cloud.duiba.payment.service.api.dto.TradePayDTO;
import cn.com.duiba.cloud.duiba.payment.service.api.param.CashierQueryParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.TradePayParam;

/**
 * 支付服务，收银台、签名
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/5 4:27 下午
 **/
@AdvancedFeignClient
public interface RemotePayService {
    /**
     * 收银台接口
     *
     * @param param
     * @return
     */
    CashierInfoDTO getCashierInfo(CashierQueryParam param) throws BizException;

    /**
     * 支付交易单，获得签名信息，用户调起三方支付组件
     *
     * @param param
     * @return
     * @throws BizException
     */
    TradePayDTO tradePay(TradePayParam param) throws BizException;
}
