package cn.com.duiba.cloud.duiba.payment.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.payment.service.api.dto.ThirdTransferResultDTO;
import cn.com.duiba.cloud.duiba.payment.service.api.param.ThirdTransferParam;
import cn.com.duiba.cloud.duiba.payment.service.api.param.ThirdTransferQueryParam;

/**
 * 三方转账接口
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/7/14 8:16 下午
 **/
@AdvancedFeignClient
public interface RemoteThirdTransferService {
    /**
     * 三方转账
     * 最终转账结果通过MQ异步通知
     * Topic:pay-notify
     * Tag:duiba-payment-event   预防：duiba-payment-event-pre
     * 消息对象 MqOrderPayNotifyModel
     * @param param
     * @return
     */
    Boolean thirdTransfer(ThirdTransferParam param) throws BizException;

    /**
     * @param param
     * @return
     * @throws BizException
     */
    ThirdTransferResultDTO queryThirdTransferResult(ThirdTransferQueryParam param) throws BizException;
}
