package cn.com.duiba.cloud.risk.engine.api.constants.enums;

import cn.com.duiba.boot.exception.BizException;
import com.google.common.collect.Lists;
import lombok.Getter;

import java.util.List;

/**
 * 黑白名单tab枚举
 */
@Getter
public enum BlackWhiteDimensionEnum {

    /**
     * 用户纬度
     */
    USER(1, Lists.newArrayList(BlackWhitePropertyTypeEnum.USER_ID, BlackWhitePropertyTypeEnum.PHONE, BlackWhitePropertyTypeEnum.ENCRYPTION_PHONE)),
    /**
     * ip地址纬度
     */
    IP(2, Lists.newArrayList(BlackWhitePropertyTypeEnum.IPV_4, BlackWhitePropertyTypeEnum.IPV_6)),
    /**
     * 地址纬度
     */
    ADDRESS(3, Lists.newArrayList(BlackWhitePropertyTypeEnum.ADDRESS)),
    ;
    private final Integer value;

    private final List<BlackWhitePropertyTypeEnum> blackWhiteDimensionEnumList;

    BlackWhiteDimensionEnum(Integer value, List<BlackWhitePropertyTypeEnum> blackWhiteDimensionEnumList) {
        this.value = value;
        this.blackWhiteDimensionEnumList = blackWhiteDimensionEnumList;
    }

    public static BlackWhiteDimensionEnum get(Integer value) throws BizException {
        for (BlackWhiteDimensionEnum item : BlackWhiteDimensionEnum.values()) {
            if (item.getValue().equals(value)) {
                return item;
            }
        }
       return null;
    }
}
