package cn.com.duiba.cloud.risk.engine.api.constants.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description 是否启用枚举类
 * @Author dangcang
 * @Date 2022/1/26 12:10 下午
 **/
@Getter
public enum EnableStatusEnum {

    /**
     * 启用状态
     */
    DIS_ENABLE(2, "未启用"),
    ENABLE(1, "启用"),
    ;

    private Integer type;

    private String desc;

    EnableStatusEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, EnableStatusEnum> ENUM_MAP = new HashMap<>();

    static {
        for (EnableStatusEnum tmp : values()) {
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static EnableStatusEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}