package cn.com.duiba.cloud.risk.engine.api.constants.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 运算符枚举
 *
 * @author zouwx
 * @date 2022/01/24
 */
@Getter
public enum OperatorEnum {

    /**
     * 运算状态符
     */
    GT(0, ">"),
    LT(1, "<"),
    EQ(2, "=="),
    GTE(3, ">="),
    LTE(4, "<="),
    NEQ(5, "!="),
    CONTAINS(6, "包含"),
    NOT_CONTAINS(7, "不包含"),

    ;

    private Integer type;

    private String desc;

    OperatorEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, OperatorEnum> ENUM_MAP = new HashMap<>();

    static {
        for (OperatorEnum tmp : values()) {
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static OperatorEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
