package cn.com.duiba.cloud.risk.engine.api.constants.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 规则范围枚举
 *
 * @author zouwx
 * @date 2022/03/28
 */
@Getter
public enum RuleScopeEnum {

    /**
     * 规则范围
     */
    ALL(1, "全局"),
    ACTIVITY(2, "活动"),
    APPLICATION(3, "应用"),
    ;

    private Integer type;

    private String desc;

    RuleScopeEnum(Integer type, String desc) {
        this.desc = desc;
        this.type = type;
    }

    private static final Map<Integer, RuleScopeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (RuleScopeEnum tmp : values()) {
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static RuleScopeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
