package cn.com.duiba.cloud.risk.engine.api.constants.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 时间枚举
 *
 * @author zouwx
 * @date 2022/01/24
 */
@Getter
public enum TimePeriodEnum {

    /**
     * 近一分钟
     */
    ONE_MINUTE(1, "近一分钟"),

    FIVE_MINUTE(2, "近五分钟"),

    ONE_HOUR(3, "近一小时"),

    ONE_DAY(4, "近一天"),

    THREE_DAY(5, "近三天"),

    SEVEN_DAY(6, "近七天"),

    UNLIMITED(7, "永不"),


    ;

    private Integer type;

    private String desc;

    TimePeriodEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, TimePeriodEnum> ENUM_MAP = new HashMap<>();

    static {
        for (TimePeriodEnum tmp : values()) {
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static TimePeriodEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
