package cn.com.duiba.cloud.risk.engine.api.dto.log;

import cn.com.duiba.cloud.risk.engine.api.constants.enums.RiskHitEnum;
import cn.com.duiba.cloud.risk.engine.api.dto.rule.RuleDetailDTO;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 策略命中详情
 *
 * @author zouwx
 * @date 2022/06/18
 */
@Data
public class StrategyHitDetailDTO implements Serializable {

    private static final long serialVersionUID = -6004839151649017684L;

    /**
     * 场景名称
     */
    private String sceneName;

    /**
     * 策略名称
     */
    private String strategyName;

    /**
     * 策略风险评分
     */
    private Integer strategyRiskScore;

    /**
     * @see RiskHitEnum
     * 结果
     */
    private Integer result;

    /**
     * 规则命中列表
     */
    private List<RuleDetailDTO> ruleList;
}
