package cn.com.duiba.cloud.risk.engine.api.dto.rule;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/2/7 10:22 上午
 **/
@Data
public class ThresholdEventDTO implements Serializable {

    private static final long serialVersionUID = 8386785864364070709L;

    /**
     * 主键id
     */
    private Long thresholdEventId;

    /**
     * 属性id
     */
    private Long eventAttrId;

    /**
     * 同一事件下关联属性值
     */
    private String eventValue;

    /**
     * 运算类型
     * @see cn.com.duiba.cloud.risk.engine.api.constants.enums.OperatorTypeEnum
     */
    private Integer operationType;

    /**
     * 删除状态（1删除 0正常）
     */
    private Integer isDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 操作列表
     */
    private List<ThresholdEventOperationDTO> operationDTOS;
}