package cn.com.duiba.cloud.risk.engine.api.param.risk;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 提供给兑吧的接口入参
 * <p>
 * consumer_id：必传
 * 策略流标识：必传,由风控提供
 * 活动长ID：：选传，没有时为空即可
 * 活动短ID：：选传，没有时为空即可
 * 活动类型：必传
 * 支付宝账号：提现场景下必填
 * 支付宝姓名：提现场景下必填
 * 位置信息：选传，没有时为空即可
 * 设备id：必传
 * IP地址：必传
 * UA：必传
 * 设备类型：IOS、Android、H5，必传
 * 请求时间：yyyy-mm-dd hh：mm：ss，必传
 *
 * @author zouwx
 * @date 2022/06/20
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ActivityRuleEngineParam extends RiskEngineParam {

    private static final long serialVersionUID = 660742843130929620L;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 活动短id
     */
    private Long activityShortId;

    /**
     * 活动类型
     */
    private String activityType;

    /**
     * 支付宝账号
     */
    private String aliPayAccount;

    /**
     * 支付宝姓名
     */
    private String aliPayName;

    /**
     * 充值账号
     */
    private String rechargeAccount;

    /**
     * 位置信息
     */
    private String position;

    /**
     * 商品id
     */
    private String itemId;

    /**
     * 助力用户id
     */
    private Long assistedUserId;

    /**
     * 游戏时长
     */
    private Integer gameTime;

    /**
     * 游戏得分
     */
    private Integer gameGoal;

    /**
     * 游戏排名
     */
    private Integer gameRank;

    /**
     * 携带积分数
     */
    private Integer creditsBring;
}
