package cn.com.duiba.cloud.risk.engine.api.param.rule;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2022/1/26 3:54 下午
 **/
@Data
public class UpdateRuleParam implements Serializable {

    private static final long serialVersionUID = 4758979212148183495L;
    /**
     * 规则id
     */
    private Long ruleId;

    /**
     * 规则名称
     */
    private String ruleName;

    /**
     * 规则范围
     */
    private Integer ruleScope;

    /**
     * 规则描述
     */
    private String ruleDesc;

    /**
     * 规则风险分
     */
    private Integer riskScore;

    /**
     * 是否需要满足所有条件
     * @see cn.com.duiba.cloud.risk.engine.api.constants.enums.RuleConditionEnum
     */
    private Integer ruleCondition;

    /**
     * 规则条件参数
     */
    private List<UpdateRuleConditionParam> ruleConditionParams;
}