package cn.com.duiba.cloud.risk.engine.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.risk.engine.api.dto.blackwhite.BlackWhiteDTO;
import cn.com.duiba.cloud.risk.engine.api.param.blackwhite.BlackWhiteQueryPageParam;
import cn.com.duiba.cloud.risk.engine.api.param.blackwhite.RemoteBlackWhiteUpdateParam;
import cn.com.duiba.cloud.risk.engine.api.param.blackwhite.RemoteQueryNameParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 黑白名单 remote
 *
 * @author zouwx
 * @date 2022/06/14
 */
@AdvancedFeignClient
public interface RemoteBlackWhiteService {

    /**
     * 分页查询黑白名单
     *
     * @param blackWhiteQueryParam 黑白色查询参数
     * @return {@link PageResponse}<{@link BlackWhiteDTO}>
     * @throws BizException 业务异常
     */
    PageResponse<BlackWhiteDTO> findByPage(BlackWhiteQueryPageParam blackWhiteQueryParam) throws BizException;

    /**
     * 批量插入
     *
     * @param blackWhiteList 黑色白名单
     */
    void batchInsert(List<BlackWhiteDTO> blackWhiteList);

    /**
     * 更新黑白名单
     *
     * @param remoteBlackWhiteUpdateParam 黑白色更新参数
     */
    void updateBlackWhite(RemoteBlackWhiteUpdateParam remoteBlackWhiteUpdateParam);

    /**
     * 删除
     *
     * @param id id
     */
    void delete(Long id);

    /**
     * 根据名称查询
     *
     * @param remoteQueryNameParam 远程查询名称参数
     * @return {@link List}<{@link BlackWhiteDTO}>
     */
    List<BlackWhiteDTO> findByNames(RemoteQueryNameParam remoteQueryNameParam);

}
