package cn.com.duiba.cloud.risk.engine.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.risk.engine.api.dto.rule.ThresholdEventDTO;
import cn.com.duiba.cloud.risk.engine.api.param.event.QueryEventConditionParam;
import cn.com.duiba.cloud.risk.engine.api.param.rule.CreateThresholdEventParam;

import java.util.List;

/**
 * @Description 规则条件
 * @Author dangcang
 * @Date 2022/2/7 9:56 上午
 **/
@AdvancedFeignClient
public interface RemoteThresholdEventService {

    /**
     * 创建阈值属性事件
     * @param param
     * @return
     * @throws BizException
     */
    Boolean createThresholdEvent(CreateThresholdEventParam param) throws BizException;

    /**
     * 删除阈值属性事件
     * @param thresholdId
     * @return
     * @throws BizException
     */
    Boolean deleteThresholdEvent(Long thresholdId) throws BizException;

    /**
     * 根据属性事件id查询阈值事件列表
     * @param eventId
     * @return
     * @throws BizException
     */
    List<ThresholdEventDTO> findByEventId(Long eventId) throws BizException;

    /**
     * 根据条件查询
     *
     * @param queryEventConditionParam 查询事件条件参数
     * @return {@link List}<{@link ThresholdEventDTO}>
     * @throws BizException 业务异常
     */
    List<ThresholdEventDTO> findByCondition(QueryEventConditionParam queryEventConditionParam) throws BizException;
}