/*
 * Copyright 1999-2018 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.cluster.client.codec.netty;

import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.cluster.client.codec.ClientEntityCodecProvider;
import com.alibaba.csp.sentinel.cluster.codec.response.ResponseEntityDecoder;
import com.alibaba.csp.sentinel.cluster.response.Response;
import com.alibaba.csp.sentinel.log.RecordLog;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;

import java.util.List;

/**
 * @author Eric Zhao
 * @since 1.4.0
 */
public class NettyResponseDecoder extends ByteToMessageDecoder {

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        ResponseEntityDecoder<ByteBuf, Response> responseDecoder = ClientEntityCodecProvider.getResponseEntityDecoder();
        if (responseDecoder == null) {
            RecordLog.warn("[NettyResponseDecoder] Cannot resolve the global response entity decoder, "
                + "dropping the response");
            return;
        }

        // TODO: handle decode error here.
        Response response = responseDecoder.decode(in);
        if (response != null) {
            out.add(response);
        }
    }
}
