/*
 * Copyright 1999-2018 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.config;

import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;

public class DuibaSentinelDataSource<T> extends AbstractDataSource<String, T> {

    private String config;

    public DuibaSentinelDataSource(String config, Converter<String, T> parser) {
        super(parser);
        this.config = config;
        loadInitialConfig();
    }

    @Override
    public String readSource() throws Exception {
        return config;
    }

    @Override
    public void close() throws Exception {

    }

    private void loadInitialConfig() {
        try {
            T newValue = loadConfig();
            if (newValue == null) {
                RecordLog.warn("[DuibaDataSource] WARN: initial config is null, you may have to check your data source");
            }
            getProperty().updateValue(newValue);
        } catch (Exception ex) {
            RecordLog.warn("[DuibaDataSource] Error when loading initial config", ex);
        }
    }
}
