package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.config;

import cn.hutool.core.util.HashUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;


/**
 * 服务管理，一致性hash
 * @author huangguosheng@duiba.com.cn
 * @date 2022/2/25 2:50 下午
 **/
@Slf4j
public class ServerManage {
    /**
     * key表示服务器的hash值，value表示服务器
     */
    private static SortedMap<Integer, String> sortedMap = new TreeMap<>();

    private static String localhost = "127.0.0.1";

    public static void initServer(List<String> servers) {
        sortedMap.clear();
        servers.forEach(server -> {
            int hash = HashUtil.fnvHash(server);
            sortedMap.put(hash, server);
            log.info("[{}]加入集合中, 其Hash值为：{}", server, hash);
        });

    }

    public static void addServer(String host) {
        int hash = HashUtil.fnvHash(host);
        sortedMap.put(hash, host);
        log.info("[{}]加入集合中, 其Hash值为：{}", host, hash);
    }

    public static String getServer(String host) {
        int hash = HashUtil.fnvHash(host);
        return sortedMap.get(hash);
    }


    public static void removeServer(String host) {
        int hash = HashUtil.fnvHash(host);
        sortedMap.remove(hash);
    }

    public static void removeServer(List<String> servers) {
        servers.forEach(server -> {
            int hash = HashUtil.fnvHash(server);
            sortedMap.remove(hash);
        });
    }

    public static List<String> getServers() {
        return new ArrayList<>(sortedMap.values());
    }

    /**
     * 得到应当路由到的结点
     *
     * @param key
     * @return
     */
    public static String getRouterServer(String key) {
        //得到该key的hash值
        if (sortedMap.size() == 0) {
            return localhost;
        }

        int hash = HashUtil.fnvHash(key);
        //得到大于该Hash值的所有Map
        SortedMap<Integer, String> subMap = sortedMap.tailMap(hash);
        if (subMap.isEmpty()) {
            //如果没有比该key的hash值大的，则从第一个node开始
            Integer i = sortedMap.firstKey();
            //返回对应的服务器
            return sortedMap.get(i);
        } else {
            //第一个Key就是顺时针过去离node最近的那个结点
            Integer i = subMap.firstKey();
            //返回对应的服务器
            return subMap.get(i);
        }
    }


    public static void main(String[] args) {


        List<String> servers = Arrays.asList("128.0.0.1", "128.0.0.2");
        ServerManage.initServer(servers);
        String[] keys = {"太阳", "月亮", "星星"};

        for (int i = 0; i < keys.length; i++) {
            System.out.println("[" + keys[i] + "]的hash值为" + HashUtil.fnvHash(keys[i])
                    + ", 被路由到结点[" + getRouterServer(keys[i]) + "]");
        }

        ServerManage.addServer("128.0.0.3");

        for (int i = 0; i < keys.length; i++) {
            System.out.println("[" + keys[i] + "]的hash值为" + HashUtil.fnvHash(keys[i])
                    + ", 被路由到结点[" + getRouterServer(keys[i]) + "]");
        }

        ServerManage.removeServer("128.0.0.2");
        ServerManage.removeServer("128.0.0.1");
        ServerManage.removeServer("128.0.0.3");
        ServerManage.addServer("128.0.0.8");
        for (int i = 0; i < keys.length; i++) {
            System.out.println("[" + keys[i] + "]的hash值为" + HashUtil.fnvHash(keys[i])
                    + ", 被路由到结点[" + getRouterServer(keys[i]) + "]");
        }

    }
}
