/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.stock.service.api.enums.stock;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public enum StockTypeEnum implements IEnum<Integer>
{
    ACTUAL_STOCK("actualStock", "\u771f\u5b9e\u5e93\u5b58", "business_platform_actual_stock", 1),
    LOT_STOCK("lotStock", "\u6279\u6b21\u5e93\u5b58", "business_platform_lot_stock", null),
    PRE_STOCK("preStock", "\u9884\u91c7\u8d2d\u5e93\u5b58", "business_platform_actual_stock", 2),
    OCCUPY_STOCK("occupyStock", "\u9884\u5360\u5e93\u5b58", "business_platform_occupy_stock", null);

    private String type;
    private String desc;
    private String measureType;
    private Integer dbCode;

    public static StockTypeEnum getStockTypeByType(String type) {
        return Stream.of(StockTypeEnum.values()).filter(t -> StringUtils.equals((CharSequence)t.type, (CharSequence)type)).findFirst().orElse(null);
    }

    private StockTypeEnum(String type, String desc, String measureType, Integer dbCode) {
        this.type = type;
        this.desc = desc;
        this.measureType = measureType;
        this.dbCode = dbCode;
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getMeasureType() {
        return this.measureType;
    }

    public Integer getDbCode() {
        return this.dbCode;
    }
}

