package cn.com.duiba.cloud.stock.service.api.enums.stock;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 库存类型枚举
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/20 6:10 下午
 **/
@AllArgsConstructor
@Getter
public enum StockTypeEnum implements IEnum<Integer> {
    /**
     * 真实库存
     */
    ACTUAL_STOCK("actualStock", "真实库存", "business_platform_actual_stock", 1),
    /**
     * 批次库存
     */
    LOT_STOCK("lotStock", "批次库存", "business_platform_lot_stock", null),

    /**
     * 预采购库存（measureType其实也等于真实库存）
     */
    PRE_STOCK("preStock", "预采购库存", "business_platform_actual_stock", 2),

    /**
     * 预占库存
     */
    OCCUPY_STOCK("occupyStock", "预占库存", "business_platform_occupy_stock", null);

    /**
     * 库存类型
     */
    private String type;

    /**
     * 描述
     */
    private String desc;

    /**
     * 计量类型
     */
    private String measureType;

    /**
     * 对应id标识(1:真实库存;2:预采购库存)
     */
    private Integer dbCode;
}