package cn.com.duiba.cloud.stock.service.api.openapi;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.openapi.service.api.annotation.OpenApi;
import cn.com.duiba.cloud.duiba.openapi.service.api.annotation.OpenPath;
import cn.com.duiba.cloud.stock.service.api.exception.OccupyError;
import cn.com.duiba.cloud.stock.service.api.exception.StockError;
import cn.com.duiba.cloud.stock.service.api.openapi.param.OpenBackOccupyStockParam;
import cn.com.duiba.cloud.stock.service.api.openapi.param.OpenEditOccupyStockParam;

import java.util.List;

/**
 * 预占库存开放接口
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.1
 **/
@OpenApi(prefix = "/stock_occupy")
@AdvancedFeignClient
public interface OpenStockOccupyService {
    /**
     * 编辑预占库存
     *
     * @param openEditOccupyStockParam 编辑预占库存请求参数
     * @return true/false
     * @throws BizException 业务异常 {@link StockError},{@link OccupyError}
     */
    @OpenPath(apiPath = "/edit_occupy_stock", apiDesc = "编辑预占库存")
    String editOccupyStock(OpenEditOccupyStockParam openEditOccupyStockParam) throws BizException;

    /**
     * 返还预占库存<br>
     * 如果backValue为0，且库存中心存在预占库存，将会逻辑删除对应的预占库存
     *
     * @param openBackOccupyStockParam 返还预占库存请求参数
     * @return 预占库存清算到0的skuId列表
     * @throws BizException 业务异常 {@link StockError},{@link OccupyError}
     */
    @OpenPath(apiPath = "/back_occupy_stock", apiDesc = "返还预占库存<br>" +
            "如果backValue为0，且库存中心存在预占库存，将会逻辑删除对应的预占库存")
    List<Long> backOccupyStock(OpenBackOccupyStockParam openBackOccupyStockParam) throws BizException;
}