package cn.com.duiba.cloud.stock.service.api.openapi.param;

import cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum;
import cn.com.duiba.cloud.stock.service.api.openapi.ApiContext;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 编辑预占库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/12/25 2:29 下午
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class OpenEditOccupyStockParam extends ApiContext implements Serializable {
    private static final long serialVersionUID = -8468893704406691978L;
    /**
     * 调度作用域id 如活动id
     */
    @NotNull(message = "预占泛id不能为空")
    private Long generalId;

    /**
     * 调度作用域类型 {@link StockOccupyEnum}
     */
    @NotNull(message = "预占类型不能为空")
    private Integer generalType;

    /**
     * 新增预占库存参数
     */
    private List<AddOccupyStockParam> addOccupyStockParamList;

    /**
     * 变更预占库存参数
     */
    private List<ChangeOccupyStockParam> changeOccupyStockParamList;

    /**
     * 清除的skuId列表
     */
    private List<Long> cleanSkuIdList;

    @Data
    @Accessors(chain = true)
    public static class AddOccupyStockParam implements Serializable {
        private static final long serialVersionUID = 7093555358862948183L;

        /**
         * skuId
         */
        @NotNull(message = "skuId不能为空")
        private Long skuId;

        /**
         * 调度值
         */
        @NotNull(message = "调度值不能为空")
        private Long dispatchValue;
    }

    @Data
    @Accessors(chain = true)
    public static class ChangeOccupyStockParam implements Serializable {
        private static final long serialVersionUID = -764943156844075826L;

        /**
         * skuId
         */
        @NotNull(message = "skuId不能为空")
        private Long skuId;

        /**
         * 更新值
         */
        @NotNull(message = "更新值不能为空")
        private Long changeValue;
    }
}
