package cn.com.duiba.cloud.stock.service.api.param.occupy;

import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 获取/释放预占库存锁请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022/1/14 7:28 下午
 * @since 0.0.1
 **/
@Data
public class OccupyLockParam implements Serializable {
    private static final long serialVersionUID = -5386694133279615871L;

    /**
     * skuId列表
     */
    @NotNull(message = "skuId不能为空")
    @Size(min = 1, max = 100, message = "skuIdList长度有误")
    private List<Long> skuIdList;
}