package cn.com.duiba.cloud.stock.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.stock.service.api.dto.stock.ConsumeStockResultDTO;
import cn.com.duiba.cloud.stock.service.api.dto.stock.CreateStockDTO;
import cn.com.duiba.cloud.stock.service.api.dto.stock.SpuStockInfoDTO;
import cn.com.duiba.cloud.stock.service.api.dto.stock.StockInfoDTO;
import cn.com.duiba.cloud.stock.service.api.exception.OccupyError;
import cn.com.duiba.cloud.stock.service.api.exception.StockError;
import cn.com.duiba.cloud.stock.service.api.param.stock.BatchGetSpuStockInfoParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.BatchGetStockInfoParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.ConsumeStockParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.GetSpuStockInfoParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.GetStockInfoParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.StockParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.UpdateStockStatusParam;

import java.util.List;

/**
 * 库存中心remote接口
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/20 1:33 下午
 **/
@AdvancedFeignClient
public interface RemoteStockService {
    /**
     * 单spuId查询总库存
     *
     * @param getSpuStockInfoParam 单spuId查询总库存请求参数
     * @return spu总库存信息
     * @throws BizException 业务异常 {@link StockError}
     */
    SpuStockInfoDTO singleGetSpuStockInfo(GetSpuStockInfoParam getSpuStockInfoParam) throws BizException;

    /**
     * 通过spuId列表批量查询总库存<br>
     * spuId每次最多支持20个
     *
     * @param batchGetSpuStockInfoParam 批量获取spu总库存请求参数
     * @return spu总库存信息
     * @throws BizException 业务异常 {@link StockError}
     */
    List<SpuStockInfoDTO> batchGetSpuStockInfo(BatchGetSpuStockInfoParam batchGetSpuStockInfoParam) throws BizException;

    /**
     * 兑吧通过skuId列表批量获取库存信息<br>
     * skuId列表最大支持50<br>
     * tip:为什么兑吧查询库存要单独开一个？因为定制，产品搞出个历史总库存的概念
     *
     * @param batchGetStockInfoParam 批量获取库存信息请求参数
     * @return 库存信息
     */
    List<StockInfoDTO> duibaBatchGetStockInfo(BatchGetStockInfoParam batchGetStockInfoParam);

    /**
     * 通过skuId单获取库存信息
     *
     * @param getStockInfoParam 单获取库存信息请求参数
     * @return 库存信息
     * @throws BizException 业务异常 {@link StockError}
     */
    StockInfoDTO singleGetStockInfo(GetStockInfoParam getStockInfoParam) throws BizException;

    /**
     * 通过skuId列表批量获取库存信息<br>
     * skuId列表最大支持50
     *
     * @param batchGetStockInfoParam 批量获取库存信息请求参数
     * @return 库存信息
     * @throws BizException 业务异常 {@link StockError}
     */
    List<StockInfoDTO> batchGetStockInfo(BatchGetStockInfoParam batchGetStockInfoParam) throws BizException;

    /**
     * 创建或修改库存<br>
     * 完全依据库存中心是否存在sku来决定是创建还是修改<br>
     * 如果上游自己有能力知晓是否创建过库存，建议调用
     * {@link RemoteStockService#createStock(cn.com.duiba.cloud.stock.service.api.param.stock.StockParam)}
     * or
     * {@link RemoteStockService#updateStock(cn.com.duiba.cloud.stock.service.api.param.stock.StockParam)}
     *
     * @param stockParam 库存请求参数
     * @return skuId和库存id映射DTO
     * @throws BizException 业务异常 {@link StockError}
     */
    List<CreateStockDTO> createOrUpdateStock(StockParam stockParam) throws BizException;

    /**
     * 创建库存
     *
     * @param stockParam 创建库存请求参数
     * @return 创建库存返回DTO
     * @throws BizException 业务异常 {@link StockError}
     */
    List<CreateStockDTO> createStock(StockParam stockParam) throws BizException;

    /**
     * 修改库存
     *
     * @param stockParam 修改库存请求参数
     * @return 修改库存返回DTO
     * @throws BizException 业务异常 {@link StockError}
     */
    List<CreateStockDTO> updateStock(StockParam stockParam) throws BizException;

    /**
     * 批量消耗库存
     *
     * @param consumeStockParam 消耗库存请求参数
     * @return 变更库存结果
     * @throws BizException 业务异常 {@link StockError},{@link OccupyError}
     */
    List<ConsumeStockResultDTO> consumeStock(ConsumeStockParam consumeStockParam) throws BizException;

    /**
     * 批量修改库存状态
     *
     * @param updateStockStatusParam 修改库存状态请求参数
     * @return true/false
     * @throws BizException 业务异常 {@link StockError},{@link OccupyError}
     */
    Boolean batchUpdateStockStatus(UpdateStockStatusParam updateStockStatusParam) throws BizException;
}