package cn.com.duiba.cloud.stock.service.api.enums.stock;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 库存流水业务类型枚举
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/23 5:10 下午
 **/
@Getter
@AllArgsConstructor
public enum StockFlowTypeEnum implements IEnum<Integer> {
    /**
     * 销售订单
     */
    ORDER(1, "销售订单", "order"),

    /**
     * 库存初始化
     */
    INIT(2, "库存初始化", "init"),

    /**
     * 修改库存
     */
    UPDATE(3, "修改库存", "update"),

    /**
     * 主库存直接预占
     */
    DISPATCH(4, "主库存直接预占", "dispatch"),

    /**
     * 活动订单
     */
    ACTIVITY(5, "活动订单", "activity"),

    /**
     * 返库
     */
    ROLLBACK(6, "返库", "rollback"),

    /**
     * 独占库存
     */
    MONOPOLIZE(7, "独占库存", "monopolize"),

    /**
     * 独占库存预占
     */
    MONOPOLIZE_DISPATCH(8, "独占库存预占", "monopolizeDispatch"),

    /**
     * 返库到独占库存
     */
    ROLLBACK_TO_MONOPOLIZE(9, "返库到独占库存", "rollbackToMonopolize"),

    /**
     * 批次过期清算
     */
    LOT_EXPIRED_CLEAR(10, "批次过期清算", "lotExpiredClear"),
    ;

    /**
     * 业务类型id
     */
    private Integer dbCode;

    /**
     * 业务类型描述
     */
    private String desc;

    /**
     * 业务场景标识
     */
    private String scene;
}