package cn.com.duiba.cloud.duiba.supplier.executor.api.model.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2021/12/29 10:29
 */
@Getter
@Setter
public class JDLaCalendarListDTO implements Serializable {

    /**
     * 状态，只有1表示处理成功
     */
    private Integer resultCode;

    /**
     * 对resultCode的简要说明
     */
    private String resultMessage;

    /**
     * 是否支持配送
     */
    private Boolean supportShip;

    /**
     * 是否支持安装
     */
    private Boolean supportInstall;

    /**
     * 是否支持夜间配送
     */
    private Boolean supportNightShip;

    /**
     * 可选的预约配送时间,只有supportShip为true时才会有值
     */
    private List<Integer> reservingDateList;

    /**
     * 可选的预约安装时间，只有supportInstall为true时才会有值
     */
    private Map<Integer, List<Integer>> reservingInstallDateMap;

    /**
     * Sku列表   List<LaSku> 不支持配送 或支持安装时，此字段有值，其他情况下，此字段为null
     */
    private List<Object> skuInfoList;

    /**
     * 预约日期列表
     */
    private List<JDCalendarListDTO> reservedCalendarList;

    /**
     * 是否支持定时达
     */
    private Boolean isSetTimeArrive;
}
