package cn.com.duiba.cloud.duiba.supplier.executor.api.model.dto;

import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2021/12/29 14:30
 */
@Getter
@Setter
public class JDParentOrderDTO {

    /**
     * 京东订单编号
     */
    private Long jdOrderId;

    /**
     * 商品列表
     */
    private List<JDSelectJdOrderSkuDTO> sku;

    /**
     * 运费
     */
    private BigDecimal freight;

    /**
     * 商品总金额（不含运费）；订单总金额是orderPrice + freight
     */
    private BigDecimal orderPrice;

    /**
     * <pre>
     * 订单未含税金额。
     * (备注：仅做页面展示，订单未税金额最终以发票票面为准。
     * 客户如需在下单后开票前，获取尽量精准的订单未税金额，如用作以未税金额扣减预算等场景，可以联系VOP侧产品配置白名单）
     * </pre>
     */
    private BigDecimal orderNakedPrice;

    /**
     * 订单税额
     */
    private BigDecimal orderTaxPrice;
}
