package cn.com.duiba.cloud.duiba.supplier.executor.api.model.dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author linzhou
 * @ClassName JDProductDetailResult.java
 * @createTime 2021年12月27日 16:22:00
 * @Description
 */
@Data
public class JDProductDetailDTO {


    /**
     * 售卖单位
     */
    @JSONField(name = "saleUnit")
    private String saleUnit;
    /**
     * 重量
     */
    @JSONField(name = "weight")
    private String weight;
    /**
     *
     */
    @JSONField(name = "wserve")
    private String wserve;
    /**
     *产地
     */
    @JSONField(name = "productArea")
    private String productArea;
    /**
     * 包装清单
     */
    @JSONField(name = "wareQD")
    private String wareQD;
    /**
     * 主图
     */
    @JSONField(name = "imagePath")
    private String imagePath;
    /**
     * 规格参数
     */
    @JSONField(name = "param")
    private String param;
    /**
     * 状态
     */
    @JSONField(name = "state")
    private Integer state;
    /**
     * 商品编号
     */
    @JSONField(name = "sku")
    private String sku;
    /**
     * 品牌名称
     */
    @JSONField(name = "brandName")
    private String brandName;
    /**
     * UPC码
     * 区分实物、图书、音像、三种场景
     */
    @JSONField(name = "upc")
    private String upc;
    @JSONField(name = "paramDetailJson")
    private List<ParamDetailJsonDTO> paramDetailJson;
    /**
     * 分类
     * 示例"670;729;4837"
     */
    @JSONField(name = "category")
    private String category;
    /**
     * 商品名称
     */
    @JSONField(name = "name")
    private String name;
    /**
     * 商品详情页大字段
     */
    @JSONField(name = "introduction")
    private String introduction;

    @Data
    public static class ParamDetailJsonDTO {
        @JSONField(name = "groupName")
        private String groupName;
        @JSONField(name = "atts")
        private List<AttsDTO> atts;

        @NoArgsConstructor
        @Data
        public static class AttsDTO {
            @JSONField(name = "attName")
            private String attName;
            @JSONField(name = "vals")
            private List<String> vals;
        }
    }
}
