package cn.com.duiba.cloud.duiba.supplier.executor.api.model.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2021/12/29 11:52
 */
@Getter
@Setter
public class JDSelectJdOrderSkuDTO implements Serializable {

    /**
     * 商品名称
     */
    private String name;

    /**
     * 京东商品编号
     */
    private Long skuId;

    /**
     * 商品数量
     */
    private Integer num;

    /**
     * 京东三级分类
     */
    private Integer category;

    /**
     * 商品价格
     */
    private BigDecimal price;

    /**
     * 商品税率。例如：本参数值返回13，代表税率为“13%”
     */
    private BigDecimal tax;

    /**
     * 主商品ID
     */
    private Integer oid;

    /**
     * 商品类型。0 普通、1 附件、2 赠品、3延保
     */
    private Integer type;

    /**
     * 运费拆分价格
     */
    private Integer splitFreight;

    /**
     * 商品税额
     */
    private Integer taxPrice;

    /**
     * 商品未含税金额
     */
    private Integer nakedPrice;
}
