package cn.com.duiba.cloud.duiba.supplier.executor.api.model.param;

import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description 查询运费请求参数
 * @date 2021/12/28 14:13
 */
@Getter
@Setter
@Builder
public class RemoteJDFreightParam implements Serializable {

    /**
     * <pre>
     *   [{"skuId":商品编号1,"num":商品数量1},{"skuId":商品编号2,"num":商品数量2}]
     * </pre>
     */
    @NotNull
    private List<RemoteJDSkuParam> sku;

    /**
     * 续重运费 conFreight
     */
    private String queryExts;

    /**
     * geoId
     */
    @NotBlank
    private String geoId;

    /**
     * 省市县区地址
     */
    @NotBlank
    private String localAddress;
}
