package cn.com.duiba.cloud.duiba.supplier.executor.api.model.param;

import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2021/12/29 09:57
 */
@Getter
@Setter
@Builder
public class RemoteJDPromiseCalendarParam implements Serializable {

    /**
     * 京东支付方式
     */
    @NotNull
    private Integer paymentType;

    /**
     * <pre>
     *   [{"skuId":商品编号1,"num":商品数量1},{"skuId":商品编号2,"num":商品数量2}]
     * </pre>
     */
    @NotNull
    private List<RemoteJDSkuParam> sku;

    /**
     * geoId
     */
    @NotBlank
    private String geoId;

    /**
     * 省市县区地址
     */
    @NotBlank
    private String localAddress;
}
