package cn.com.duiba.cloud.duiba.supplier.executor.api.remoteservice.jd;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.supplier.executor.api.model.dto.JDConfirmInfoDTO;
import cn.com.duiba.cloud.duiba.supplier.executor.api.model.dto.JDFreightDTO;
import cn.com.duiba.cloud.duiba.supplier.executor.api.model.dto.JDOrderTrackDTO;
import cn.com.duiba.cloud.duiba.supplier.executor.api.model.dto.JDParentSelectJdOrderDTO;
import cn.com.duiba.cloud.duiba.supplier.executor.api.model.dto.JDPromiseCalendarDTO;
import cn.com.duiba.cloud.duiba.supplier.executor.api.model.dto.JDSubSelectJdOrderDTO;
import cn.com.duiba.cloud.duiba.supplier.executor.api.model.param.RemoteJDBatchConfirmReceivedParam;
import cn.com.duiba.cloud.duiba.supplier.executor.api.model.param.RemoteJDCancelParam;
import cn.com.duiba.cloud.duiba.supplier.executor.api.model.param.RemoteJDConfirmOrderParam;
import cn.com.duiba.cloud.duiba.supplier.executor.api.model.param.RemoteJDConfirmReceivedParam;
import cn.com.duiba.cloud.duiba.supplier.executor.api.model.param.RemoteJDFreightParam;
import cn.com.duiba.cloud.duiba.supplier.executor.api.model.param.RemoteJDOrderTrackParam;
import cn.com.duiba.cloud.duiba.supplier.executor.api.model.param.RemoteJDPlaceOrderParam;
import cn.com.duiba.cloud.duiba.supplier.executor.api.model.param.RemoteJDPromiseCalendarParam;
import cn.com.duiba.cloud.duiba.supplier.executor.api.model.param.RemoteSelectJdOrderParam;
import com.alibaba.fastjson.JSONObject;

import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/1/4 14:43
 */
@AdvancedFeignClient
public interface RemoteJDOrderService {

    /**
     * <pre>
     * 查询运费接口
     * </pre>
     * @param param 请求参数
     * @return JDFreightDTO
     * @throws BizException 业务异常
     */
    JDFreightDTO getFreight(RemoteJDFreightParam param) throws BizException;

    /**
     * <pre>
     * 预约日历
     * </pre>
     * @param param 请求参数
     * @return JDPromiseCalendarDTO
     * @throws BizException 业务异常
     */
    JDPromiseCalendarDTO promiseCalendar(RemoteJDPromiseCalendarParam param) throws BizException;

    /**
     * <pre>
     * 生成订单
     *
     * 当入参的京东订单编号没有子单时，返回“子单响应参数”，当入参的京东订单编号有子单时，返回“父单响应参数”
     * 根据返回的pOrder，判断类型，如果是Integer表示子单，如果是对象，表示父单
     * - 如果返回子单响应参数 {@link JDSubSelectJdOrderDTO}
     * - 如果返回父单响应参数 {@link JDParentSelectJdOrderDTO}
     * </pre>
     * @param param 生成订单参数
     * @return JSONObject
     * @throws BizException 业务异常
     */
    JSONObject placeOrder(RemoteJDPlaceOrderParam param) throws BizException;

    /**
     * 查询订单详情
     * <pre>
     *     当入参的京东订单编号没有子单时，返回“子单响应参数”，当入参的京东订单编号有子单时，返回“父单响应参数”
     *     - 如果返回子单响应参数 {@link JDSubSelectJdOrderDTO}
     *     - 如果返回父单响应参数 {@link JDParentSelectJdOrderDTO}
     * </pre>
     * @param param 查询参数
     * @return JDBaseResult<JSONObject>
     */
    JSONObject selectJdOrder(RemoteSelectJdOrderParam param);

    /**
     * <pre>
     * 确认预占库存订单
     * </pre>
     * @param param 查询参数
     * @return 状态，此值同success
     * @throws BizException 业务异常
     */
    Boolean confirmOrder(RemoteJDConfirmOrderParam param) throws BizException;

    /**
     * 取消未确认订单
     * @param param 提交参数
     * @return 状态，此值同success
     */
    Boolean cancel(RemoteJDCancelParam param);

    /**
     * 查询配送信息
     * @param param 查询参数
     * @return 配送信息
     */
    JDOrderTrackDTO orderTrack(RemoteJDOrderTrackParam param);

    /**
     * <pre>
     * 确认收货
     *
     * 适用于查询订单详情接口中orderType=5和orderType=11，40类型的订单可使用此接口确认收货
     * 并将订单置为完成状态
     * </pre>
     * @param param 请求参数
     * @return 无实际意义
     * @throws BizException 业务异常
     */
    String confirmReceived(RemoteJDConfirmReceivedParam param) throws BizException;

    /**
     * 批量确认收货接口
     * @param param 查询参数
     * @return 消息内容
     */
    List<JDConfirmInfoDTO> batchConfirmReceived(RemoteJDBatchConfirmReceivedParam param);
}
