package cn.com.duiba.cloud.duiba.supplier.executor.api.model.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <pre>
 * example:
 * {
 *     "success":true,
 *     "resultMessage":"",
 *     "resultCode":"0000",
 *     "result":{
 *         "freight":25,
 *         "baseFreight":5,
 *         "remoteRegionFreight":20,
 *         "remoteSku":"[123456,234232]",
 *         "conFreight":25
 *     }
 * }
 * </pre>
 * @author yuanzhixin
 * @version 1.0
 * @date 2021/12/28 14:08
 */
@Getter
@Setter
public class JDFreightDTO implements Serializable {

    /**
     * 总运费
     */
    private BigDecimal freight;

    /**
     * 基础运费
     */
    private BigDecimal baseFreight;

    /**
     * 偏远地区加收运费
     */
    private BigDecimal remoteRegionFreight;

    /**
     * 需收取偏远运费的sku
     */
    private String remoteSku;

    /**
     * 续重运费
     */
    private BigDecimal conFreight;
}
