package cn.com.duiba.cloud.duiba.supplier.executor.api.model.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2021/12/29 15:25
 */
@Getter
@Setter
public class JDChildOrderDTO implements Serializable {

    /**
     * 父订单号。为0时，此订单为父单
     */
    private Integer pOrder;

    /**
     * 订单状态。0为取消订单  1为有效。2为被二次或是多次拆分的无效订单
     */
    private Integer orderState;

    /**
     * 京东订单编号
     */
    private Long jdOrderId;

    /**
     * 物流状态 0 是新建 1是妥投 2是拒收
     */
    private Integer state;

    /**
     * 预占确认状态 0没确认预占 1已确认预占
     */
    private Integer submitState;

    /**
     * 订单类型 1是父订单 2是子订单 3是被二次或是多次拆分的无效订单
     */
    private Integer type;

    /**
     * 运费：收取运费时返回
     */
    private BigDecimal freight;

    /**
     * 商品列表
     */
    private List<JDSelectJdOrderSkuDTO> sku;

    /**
     * 商品总金额（不含运费）；订单总金额是orderPrice + freight
     */
    private BigDecimal orderPrice;

    /**
     * <pre>
     * 订单未含税金额。
     * (备注：仅做页面展示，订单未税金额最终以发票票面为准。
     * 客户如需在下单后开票前，获取尽量精准的订单未税金额，如用作以未税金额扣减预算等场景，可以联系VOP侧产品配置白名单）
     * </pre>
     */
    private BigDecimal orderNakedPrice;

    /**
     * 订单税额
     */
    private BigDecimal orderTaxPrice;

    /**
     * 无货预定商品可能出现该字段
     */
    private Integer arriveTime;
}
