package cn.com.duiba.cloud.duiba.supplier.executor.api.model.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2021/12/29 11:50
 */
@Getter
@Setter
public class JDParentSelectJdOrderDTO implements Serializable {

    /**
     * 父订单详情
     */
    private JDParentOrderDTO pOrder;

    /**
     * 子订单详情
     */
    private List<JDChildOrderDTO> cOrder;

    /**
     * 订单状态。0为取消订单  1为有效。2为被二次或是多次拆分的无效订单
     */
    private Integer orderState;

    /**
     * 预占确认状态 0没确认预占 1已确认预占
     */
    private Integer submitState;

    /**
     * 订单类型 1是父订单 2是子订单 3是被二次或是多次拆分的无效订单
     */
    private Integer type;

    /**
     * <pre>
     * 订单类别。
     * 查询参数queryExts中包含orderType。参考枚举值如下：
     * 1.普通商品
     * 2.大家电
     * 3.实物礼品卡
     * 4.售后换新单
     * 5.厂家直送订单
     * 6.FBP订单
     * 7.生鲜
     * 11.ibs订单
     * 20.电子卡
     * 40. ICF工业品订单
     * </pre>
     */
    private Integer orderType;

    /**
     * <pre>
     * 订单创建时间。
     * 查询参数queryExts中包含createOrderTime。
     * 输出格式为“yyyy-MM-dd hh:mm:ss”
     * </pre>
     */
    private String createOrderTime;

    /**
     * 订单完成时间。
     * 查询参数queryExts中包含finishTime。
     * 输出格式为“yyyy-MM-dd hh:mm:ss”
     * 未完成时，此参数返回null
     */
    private String finishTime;

    /**
     * <pre>
     * 京东状态。查询参数中包含queryExts=jdOrderState。参考枚举值如下：
     * 1.新单
     * 2.等待支付
     * 3.等待支付确认
     * 4.延迟付款确认
     * 5.订单暂停
     * 6.店长最终审核
     * 7.等待打印
     * 8.等待出库
     * 9.等待打包
     * 10.等待发货
     * 11.自提途中
     * 12.上门提货
     * 13.自提退货
     * 14.确认自提
     * 16.等待确认收货
     * 17.配送退货
     * 18.货到付款确认
     * 19.已完成
     * 21.收款确认
     * 22.锁定
     * </pre>
     */
    private Integer jdOrderState;
}
