package cn.com.duiba.cloud.duiba.supplier.executor.api.model.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Map;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2021/12/29 10:02
 */
@Getter
@Setter
public class JDSkuClassifyDTO implements Serializable {

    /**
     *  状态，只有1表示处理成功
     */
    private Integer resultCode;

    /**
     * 对resultCode的简要说明
     */
    private String resultMessage;

    /**
     * <pre>
     * 详细区分结果，
     * "skuClassifyMaps": {
     *    "100780": 1, // 100780表示sku;1表示类型（1具体指中小件）
     *    “1000116": 2// 1000116表示sku;2表示类型（2具体指大家电）
     *  }
     * key表示sku编码;
     * value表示sku类型，1：表示中小件，2：表示大家电
     * </pre>
     */
    private Map<Long, Integer> skuClassifyMaps;
}
