package cn.com.duiba.cloud.duiba.supplier.executor.api.model.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2021/12/29 11:50
 */
@Getter
@Setter
public class JDSubSelectJdOrderDTO implements Serializable {

    /**
     * 父订单号。为0时，此订单为父单
     */
    private Integer pOrder;

    /**
     * 订单状态。0为取消订单  1为有效。2为被二次或是多次拆分的无效订单
     */
    private Integer orderState;

    /**
     * 京东订单编号
     */
    private Long jdOrderId;

    /**
     * 物流状态 0 是新建 1是妥投 2是拒收
     */
    private Integer state;

    /**
     * 预占确认状态 0没确认预占 1已确认预占
     */
    private Integer submitState;

    /**
     * 订单类型 1是父订单 2是子订单 3是被二次或是多次拆分的无效订单
     */
    private Integer type;

    /**
     * 运费：收取运费时返回
     */
    private BigDecimal freight;

    /**
     * 商品列表
     */
    private List<JDSelectJdOrderSkuDTO> sku;

    /**
     * 商品总金额（不含运费）；订单总金额是orderPrice + freight
     */
    private BigDecimal orderPrice;

    /**
     * <pre>
     * 订单未含税金额。
     * (备注：仅做页面展示，订单未税金额最终以发票票面为准。
     * 客户如需在下单后开票前，获取尽量精准的订单未税金额，如用作以未税金额扣减预算等场景，可以联系VOP侧产品配置白名单）
     * </pre>
     */
    private BigDecimal orderNakedPrice;

    /**
     * 订单税额
     */
    private BigDecimal orderTaxPrice;

    /**
     * <pre>
     * 订单类别。
     * 查询参数queryExts中包含orderType。参考枚举值如下：
     * 1.普通商品
     * 2.大家电
     * 3.实物礼品卡
     * 4.售后换新单
     * 5.厂家直送订单
     * 6.FBP订单
     * 7.生鲜
     * 11.IBS订单
     * 20.电子卡
     * 40. ICF工业品订单
     * </pre>
     */
    private Integer orderType;

    /**
     * <pre>
     * 订单创建时间。
     * 查询参数queryExts中包含createOrderTime。
     * 输出格式为“yyyy-MM-dd hh:mm:ss”
     * </pre>
     */
    private String createOrderTime;

    /**
     * 订单完成时间。
     * 查询参数queryExts中包含finishTime。
     * 输出格式为“yyyy-MM-dd hh:mm:ss”
     * 未完成时，此参数返回null
     */
    private String finishTime;

    /**
     * <pre>
     * 京东状态。查询参数中包含queryExts=jdOrderState。参考枚举值如下：
     * 1.新单
     * 2.等待支付
     * 3.等待支付确认
     * 4.延迟付款确认
     * 5.订单暂停
     * 6.店长最终审核
     * 7.等待打印
     * 8.等待出库
     * 9.等待打包
     * 10.等待发货
     * 11.自提途中
     * 12.上门提货
     * 13.自提退货
     * 14.确认自提
     * 16.等待确认收货
     * 17.配送退货
     * 18.货到付款确认
     * 19.已完成
     * 21.收款确认
     * 22.锁定
     * </pre>
     */
    private Integer jdOrderState;

    /**
     * <pre>
     * 支付方式枚举值
     * 1：货到付款
     * 4：预存款
     * 5：公司转账
     * 101：京东金采
     * 102：商城金采(一般不适用，仅限确认开通商城账期的特殊情况使用，请与业务确认后使用)
     * 20为混合支付
     * </pre>
     */
    private Integer paymentType;

    /**
     * <pre>
     * 混合支付明细，
     * 当paymentType为20混合支付，返回值
     * [
     *     {
     *         "payMoney":20,
     *         "paymentType":"17",
     *         "flag":"1"
     *     },
     *     {
     *         "payMoney":80,
     *         "paymentType":"4",
     *         "flag":"2"
     *     }
     * ]
     * </pre>
     */
    private List<JDPayDetailsDTO> payDeatails;

    /**
     * 京东配送订单的出库时间/厂家直送订单的确认发货时间"2019-10-12 10:21:44"
     */
    private Date outTime;

    /**
     * 下单时的开票类型
     * 2 增值税专用发票；3 电子票
     */
    private String invoiceType;

    /**
     * 无货预定商品可能出现该字段
     */
    private Integer arriveTime;

}
