package cn.com.duiba.cloud.duiba.supplier.executor.api.model.param;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/1/4 14:48
 */
@Getter
@Setter
public class RemoteJDPlaceOrderParam implements Serializable {

    /**
     * <pre>
     *   [{"skuId":商品编号1,"num":商品数量1},{"skuId":商品编号2,"num":商品数量2}]
     * </pre>
     */
    @NotNull(message = "sku 不能为空")
    private List<RemoteJDSkuParam> sku;

    /**
     * 续重运费 conFreight
     */
    private String queryExts;

    /**
     * geoId
     */
    @NotBlank(message = "geoId 不能为空")
    private String geoId;

    /**
     * 第三方的订单单号
     */
    @NotBlank(message = "thirdOrder 不能为空")
    @Length(max = 100)
    private String thirdOrder;

    /**
     * 收货人姓名
     */
    @NotBlank(message = "name 不能为空")
    @Length(max = 20)
    private String name;

    /**
     * 收货人详细地址
     */
    @NotBlank(message = "address 不能为空")
    @Length(max = 100)
    private String address;


    /**
     * 手机号
     */
    @NotBlank(message = "mobile 不能为空")
    @Length(max = 20)
    private String mobile;

    /**
     * 发票类型（2 增值税专用发票；3 电子票）
     * 当发票类型为2时，开票方式只支持2集中开票
     */
    @NotNull(message = "invoiceType 不能为空")
    private Integer invoiceType;

    /**
     * 发票抬头  (如果selectedInvoiceTitle=5则此字段必须) 需regCompanyName跟此字段传递一致
     */
    @NotBlank(message = "companyName 不能为空")
    private String companyName;

    /**
     * 1:明细，100：大类
     * 备注:若增值税专用发票则只能选1 明细
     */
    @NotNull(message = "invoiceContent 不能为空")
    private Integer invoiceContent;

    /**
     * 收票人电话
     */
    @NotBlank(message = "invoicePhone 不能为空")
    private String invoicePhone;

    /**
     * 专票资质公司名称
     */
    @NotBlank(message = "regCompanyName 不能为空")
    private String regCompanyName;

    /**
     * 专票资质纳税人识别号
     */
    @NotBlank(message = "regCode 不能为空")
    private String regCode;

    /**
     * 省市县区地址
     */
    @NotBlank(message = "localAddress 不能为空")
    private String localAddress;
}
