package cn.com.duiba.cloud.duiba.supplier.executor.api.model.param;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/1/12 14:15
 */
@Getter
@Setter
public class RemoteJDSkuParam implements Serializable {

    /**
     * 商品编号
     */
    @NotNull(message = "skuId 不能为空")
    private Long skuId;

    /**
     * 商品数量
     */
    @NotNull(message = "num 不能为空")
    private Long num;

    /**
     * 成本价（单位元，小数点后两位，下单时必传）
     */
    private BigDecimal price;

    /**
     * 是否需要赠品
     */
    private Boolean bNeedGift;
}
