package cn.com.duiba.cloud.thirdparty.channel.server.api.param;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 微信二维码配置
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/6/10 10:25 上午
 **/
@Data
public class WechatQrCodeConfigParam implements Serializable {
    private static final long serialVersionUID = -3652149873546229963L;

    /**
     * 应用id
     */
    @NotNull(message = "appId不能为空")
    private String appId;

    /**
     * 二维码Url
     */
    @NotNull(message = "二维码Url不能为空")
    private String qrCodeUrl;
}
