package cn.com.duiba.cloud.thirdparty.channel.server.api.remoteservice.wechat;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.thirdparty.channel.server.api.dto.WechatQrCodeConfigDTO;
import cn.com.duiba.cloud.thirdparty.channel.server.api.param.WechatQrCodeConfigParam;

/**
 * 微信配置服务
 * @author huangguosheng@duiba.com.cn
 * @date 2022/6/10 10:24 上午
 **/
@AdvancedFeignClient
public interface RemoteWechatConfigService {
    /**
     * 保存微信二维码配置
     *
     * @param param
     */
    void saveWechatQrcodeConfig(WechatQrCodeConfigParam param);

    /**
     * 获取微信二维码配置
     *
     * @param appId
     * @return
     */
    WechatQrCodeConfigDTO getWechatQrCodeConfig(String appId);
}
