/**
 * Copyright (c) 2021- All Rights Reserved.
 */
package cn.com.duiba.cloud.thirdparty.channel.server.api.enums;

import lombok.Getter;

/**
 * 用户类型
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/8 10:50 上午
 **/
@Getter
public enum ThirdPartyUserTypeEnum {
    PLATFORM(1, "平台"),
    WECHAT_APP(2, "微信app"),
    TENANT(3, "租户"),
    /**
     * 应用时 userId 传应用id
     */
    APPLICATION(4, "应用"),

    C_USER(5, "C端用户"),

    ;


    private Integer value;

    private String desc;

    ThirdPartyUserTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (ThirdPartyUserTypeEnum item : ThirdPartyUserTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static ThirdPartyUserTypeEnum valueOf(Integer value) {
        for (ThirdPartyUserTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
