package cn.com.duiba.cloud.thirdparty.channel.server.api.enums;

import lombok.Getter;

/**
 * 1则商户扫码后，手机端仅展示公众号 2表示仅展示小程序，3表示公众号和小程序都展示。
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/6/13 11:18 上午
 **/
@Getter
public enum WechatAuthTypeEnum {
    /**
     * 1则商户扫码后，手机端仅展示公众号 2表示仅展示小程序，3表示公众号和小程序都展示。
     */
    WECHAT(1, "展示公众号"),

    WECHAT_MINI_APP(2, "展示小程序"),

    ALL(3, "公众号和小程序都展示"),
    ;


    private Integer value;

    private String desc;

    WechatAuthTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (WechatAuthTypeEnum item : WechatAuthTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static WechatAuthTypeEnum valueOf(Integer value) {
        for (WechatAuthTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
